/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler;

import com.terraforged.mod.profiler.Profiler;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public class ProfilerPrinter {
    private static final String FORMAT = "%1$-20s%2$-11s%3$-11s%4$-11s%5$-11s%6$-1s";

    public static void print(Writer writer) throws IOException {
        ProfilerPrinter.print(writer, "");
    }

    public static void print(Writer writer, String indent) throws IOException {
        writer.append(indent).append(String.format(FORMAT, "Section", "Count", "Time MS", "Min MS", "Max MS", "Average MS"));
        double averageSum = 0.0;
        for (Profiler profiler : Profiler.values()) {
            String name = profiler.name().toLowerCase(Locale.ROOT);
            long hits = profiler.hits();
            long time = profiler.timeMS();
            long min = profiler.minMS();
            long max = profiler.maxMS();
            double average = profiler.averageMS();
            writer.append("\n").append(indent).append(String.format(FORMAT, name, hits, time, min, max, ProfilerPrinter.fmt(average)));
            averageSum += average;
        }
        writer.append("\n").append(indent).append(String.format(FORMAT, "Sum", "", "", "", "", ProfilerPrinter.fmt(averageSum)));
    }

    private static String fmt(double value) {
        return String.format("%.2f", value);
    }
}

